<?php

if ( ! function_exists( 'boostup_mikado_loading_spinners' ) ) {
	function boostup_mikado_loading_spinners() {
		$id           = boostup_mikado_get_page_id();
		$spinner_type = boostup_mikado_get_meta_field_intersect( 'smooth_pt_spinner_type', $id );
		
		$spinner_html = '';
		if ( ! empty( $spinner_type ) ) {
			switch ( $spinner_type ) {
				case 'rotate_circles':
					$spinner_html = boostup_mikado_loading_spinner_rotate_circles();
					break;
				case 'pulse':
					$spinner_html = boostup_mikado_loading_spinner_pulse();
					break;
				case 'double_pulse':
					$spinner_html = boostup_mikado_loading_spinner_double_pulse();
					break;
				case 'cube':
					$spinner_html = boostup_mikado_loading_spinner_cube();
					break;
				case 'rotating_cubes':
					$spinner_html = boostup_mikado_loading_spinner_rotating_cubes();
					break;
				case 'stripes':
					$spinner_html = boostup_mikado_loading_spinner_stripes();
					break;
				case 'wave':
					$spinner_html = boostup_mikado_loading_spinner_wave();
					break;
				case 'two_rotating_circles':
					$spinner_html = boostup_mikado_loading_spinner_two_rotating_circles();
					break;
				case 'five_rotating_circles':
					$spinner_html = boostup_mikado_loading_spinner_five_rotating_circles();
					break;
				case 'atom':
					$spinner_html = boostup_mikado_loading_spinner_atom();
					break;
				case 'clock':
					$spinner_html = boostup_mikado_loading_spinner_clock();
					break;
				case 'mitosis':
					$spinner_html = boostup_mikado_loading_spinner_mitosis();
					break;
				case 'lines':
					$spinner_html = boostup_mikado_loading_spinner_lines();
					break;
				case 'fussion':
					$spinner_html = boostup_mikado_loading_spinner_fussion();
					break;
				case 'wave_circles':
					$spinner_html = boostup_mikado_loading_spinner_wave_circles();
					break;
				case 'pulse_circles':
					$spinner_html = boostup_mikado_loading_spinner_pulse_circles();
					break;
				case 'pulse_boost':
					$spinner_html = boostup_mikado_loading_spinner_pulse_boost();
					break;
				default:
					$spinner_html = boostup_mikado_loading_spinner_pulse();
			}
		}
		
		echo wp_kses( $spinner_html, array(
			'div' => array(
				'class' => true,
				'style' => true,
				'id'    => true
			),
			'svg' => array(
			    'version'               => true,
			    'xmlns'                 => true,
			    'x'                     => true,
			    'y'                     => true,
			    'width'                 => true,
			    'height'                => true,
			    'viewBox'               => true,
			    'enable-background'     => true
			),
			'path' => array(
			    'x'                     => true,
			    'y'                     => true,
			    'd'                     => true,
			    'width'                 => true,
			    'height'                => true,
			    'fill'                  => true,
			    'stroke'                => true,
			    'stroke-width'          => true,
			    'stroke-miterlimit'     => true
			)
		) );
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_rotate_circles' ) ) {
	function boostup_mikado_loading_spinner_rotate_circles() {
		$html = '';
		$html .= '<div class="mkdf-rotate-circles">';
		$html .= '<div></div>';
		$html .= '<div></div>';
		$html .= '<div></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_pulse' ) ) {
	function boostup_mikado_loading_spinner_pulse() {
		$html = '<div class="pulse"></div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_double_pulse' ) ) {
	function boostup_mikado_loading_spinner_double_pulse() {
		$html = '';
		$html .= '<div class="double_pulse">';
		$html .= '<div class="double-bounce1"></div>';
		$html .= '<div class="double-bounce2"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_cube' ) ) {
	function boostup_mikado_loading_spinner_cube() {
		$html = '<div class="cube"></div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_rotating_cubes' ) ) {
	function boostup_mikado_loading_spinner_rotating_cubes() {
		$html = '';
		$html .= '<div class="rotating_cubes">';
		$html .= '<div class="cube1"></div>';
		$html .= '<div class="cube2"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_stripes' ) ) {
	function boostup_mikado_loading_spinner_stripes() {
		$html = '';
		$html .= '<div class="stripes">';
		$html .= '<div class="rect1"></div>';
		$html .= '<div class="rect2"></div>';
		$html .= '<div class="rect3"></div>';
		$html .= '<div class="rect4"></div>';
		$html .= '<div class="rect5"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_wave' ) ) {
	function boostup_mikado_loading_spinner_wave() {
		$html = '';
		$html .= '<div class="wave">';
		$html .= '<div class="bounce1"></div>';
		$html .= '<div class="bounce2"></div>';
		$html .= '<div class="bounce3"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_two_rotating_circles' ) ) {
	function boostup_mikado_loading_spinner_two_rotating_circles() {
		$html = '';
		$html .= '<div class="two_rotating_circles">';
		$html .= '<div class="dot1"></div>';
		$html .= '<div class="dot2"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_five_rotating_circles' ) ) {
	function boostup_mikado_loading_spinner_five_rotating_circles() {
		$html = '';
		$html .= '<div class="five_rotating_circles">';
		$html .= '<div class="spinner-container container1">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '<div class="spinner-container container2">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '<div class="spinner-container container3">';
		$html .= '<div class="circle1"></div>';
		$html .= '<div class="circle2"></div>';
		$html .= '<div class="circle3"></div>';
		$html .= '<div class="circle4"></div>';
		$html .= '</div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_atom' ) ) {
	function boostup_mikado_loading_spinner_atom() {
		$html = '';
		$html .= '<div class="atom">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_clock' ) ) {
	function boostup_mikado_loading_spinner_clock() {
		$html = '';
		$html .= '<div class="clock">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_mitosis' ) ) {
	function boostup_mikado_loading_spinner_mitosis() {
		$html = '';
		$html .= '<div class="mitosis">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_lines' ) ) {
	function boostup_mikado_loading_spinner_lines() {
		$html = '';
		$html .= '<div class="lines">';
		$html .= '<div class="line1"></div>';
		$html .= '<div class="line2"></div>';
		$html .= '<div class="line3"></div>';
		$html .= '<div class="line4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_fussion' ) ) {
	function boostup_mikado_loading_spinner_fussion() {
		$html = '';
		$html .= '<div class="fussion">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}

if ( ! function_exists( 'boostup_mikado_loading_spinner_wave_circles' ) ) {
	function boostup_mikado_loading_spinner_wave_circles() {
		$html = '';
		$html .= '<div class="wave_circles">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}
if ( ! function_exists( 'agava_mikado_loading_spinner_pulse_circles' ) ) {
	function boostup_mikado_loading_spinner_pulse_circles() {
		$html = '';
		$html .= '<div class="pulse_circles">';
		$html .= '<div class="ball ball-1"></div>';
		$html .= '<div class="ball ball-2"></div>';
		$html .= '<div class="ball ball-3"></div>';
		$html .= '<div class="ball ball-4"></div>';
		$html .= '</div>';
		
		return $html;
	}
}
if ( ! function_exists( 'boostup_mikado_loading_spinner_pulse_boost' ) ) {
	function boostup_mikado_loading_spinner_pulse_boost() {
		$html = '';
		$html .= '<div class="mkdf-boostup-loader">';
		$html .= '<div class="mkdf-icon-up-bg"></div>';
		$html .= '<div class="mkdf-icon-up">';
		$html .= '<svg xmlns="http://www.w3.org/2000/svg" width="33.371px" height="50px" viewBox="0 0 33.371 48.833" enable-background="new 0 0 33.371 48.833"><path fill="#ea3d56" d="M32.643,22.556c-0.417,0.543-3.237,1.685-3.237,1.685c-0.679,0.381-1.462,0.707-2.141,1.142c-0.157,0.108-0.209,0.272-0.314,0.435c-0.261,0.543-0.626,1.033-0.992,1.522c-0.679,0.869-1.514,1.086-2.507,0.924c-0.261,0-0.417-0.272-0.313-0.598c0.052-0.326,0.157-0.598,0.417-0.815c0.157-0.218,0.366-0.434,0.575-0.598c0.261-0.217,0.522-0.38,0.731-0.597c0.209-0.109,0.313-0.272,0.418-0.489c0.417-1.033,0.574-2.121,0.47-3.261
	c0-0.055-0.052-0.109-0.052-0.164c-0.104,0-0.209,0.055-0.261,0.109l-0.157,0.163c-0.992,1.304-1.984,2.61-2.872,3.968c-0.366,0.652-2.611,6.414-3.133,8.099c-0.626,2.012-1.41,4.022-2.246,5.979c-0.574,1.25-1.096,2.555-1.775,3.751l-0.575,0.978c-0.261,0.327-1.515,2.174-2.35,2.773c-1.306,0.924-1.724,0.163-1.828-0.652v-0.544V46.31c0-0.218,0-0.435,0.052-0.652
	c0.366-3.153,1.567-5.98,2.872-8.698c1.044-2.228,2.141-4.402,3.342-6.577c0.105-0.163,1.202-2.174,1.828-3.207l0.543-1.38l-0.019,0.022c-0.261,0.435-2.193,2.391-2.246,2.446l-0.888,0.924c-0.261,0.218-0.47,0.435-0.731,0.598c-0.627,0.489-1.41,0.706-2.193,0.652c-0.209,0-0.417,0.054-0.626,0c-0.261,0-0.47,0-0.731-0.109
	c-0.417-0.163-0.679-0.435-0.835-0.924c-0.104-0.489-0.157-0.924-0.104-1.468c0.104-1.848,0.522-3.696,1.148-5.436c0.052-0.271,0.209-0.543,0.157-0.815c-0.313,0.218-0.522,0.597-0.783,0.924c-0.888,1.25-1.775,2.5-2.768,3.642c-0.887,1.088-1.932,2.012-3.028,2.881c-0.992,0.761-2.088,0.978-3.237,0.815c-0.47-0.054-0.836-0.381-0.992-0.87C1.104,28.589,1,28.045,1,27.502c0-1.74,0.261-3.425,0.626-5.11c0.418-2.011,1.044-3.967,1.776-5.87c1.044-2.773,2.193-5.544,3.446-8.208c0.94-2.011,1.932-4.022,3.133-5.871l1.044-1.413c0.104-0.109,0.261-0.164,0.366-0.272l0.104,0.055c-0.052,0.435,0.157,0.163,0.313,0.163l0.783-0.163c0.522-0.109,0.888,0.163,1.253,0.49c0.209,0.217,0.366,0.434,0.574,0.706c0.053,0.055,0.104,0.218,0.104,0.327c-0.052,0.271-0.104,0.597-0.261,0.924c-0.366,0.87-0.835,1.685-1.253,2.555c-1.044,2.12-2.089,4.348-2.977,6.577c-0.835,1.957-1.619,3.967-2.402,5.979c-1.097,2.772-2.141,5.544-3.186,8.371c-0.156,0.381-0.261,0.761-0.365,1.142c-0.052,0.163-0.052,0.381-0.052,0.543c0.208,0.055,0.365-0.109,0.47-0.218c0.47-0.326,0.992-0.706,1.462-1.086c1.044-0.924,1.984-1.957,2.82-3.098c1.41-1.848,2.768-3.697,4.021-5.653c1.306-1.957,2.455-3.914,3.342-6.143c0.104-0.326,0.313-0.598,0.574-0.815c0.104-0.054,0.209-0.054,0.261,0.109c0.052,0.163,0.157,0.271,0.313,0.163c0.366-0.271,0.73-0.271,1.096-0.217c0.418,0,0.783,0.271,1.044,0.543l0.731,0.815c0.157,0.163,0.209,0.327,0.209,0.543c-0.105,0.38-0.157,0.761-0.261,1.142
	c-0.313,0.707-0.575,1.413-0.94,2.12c-1.253,2.609-2.297,5.327-3.185,8.153c-0.261,0.87-0.575,1.739-0.888,2.609c-0.052,0.163-0.157,0.327-0.157,0.489c-0.052,0.054,0,0.163,0,0.218h0.261c0.836-0.326,1.567-1.033,2.141-1.685c0.996-1.141,2.734-3.248,2.985-3.537c0.581-1.371,1.191-2.736,1.87-4.074l0.157-0.38c0.104-0.218,0.261-0.327,0.522-0.327c0.366,0,0.627,0.218,0.627,0.599c0.052,0.163,0,0.38,0,0.543c-0.157,0.599-0.261,1.142-0.366,1.739v0.109c0.052-0.054,0.104-0.054,0.104-0.054l0.47-0.489c0.261-0.163,0.47-0.38,0.731-0.543c0.313-0.218,0.626-0.327,0.992-0.271c0.208,0.054,0.47,0.054,0.679,0.054c0.156,0.055,0.366,0.109,0.522,0.218c0.575,0.38,0.94,0.924,1.097,1.63c0.104,0.544,0.104,1.142,0,1.685v0.381c0,0,0.052,0.055,0.104,0.055c0.157-0.055,0.261-0.163,0.418-0.218c0.73-0.38,2.715-1.304,3.603-1.413C32.121,22.121,32.8,22.338,32.643,22.556z"></path></svg>';
		$html .= '</div>';
		$html .= '</div>';
		
		return $html;
	}
}
