(function($) {
    'use strict';

    var woocommerce = {};
    mkdf.modules.woocommerce = woocommerce;

    woocommerce.mkdfOnDocumentReady = mkdfOnDocumentReady;

    $(document).ready(mkdfOnDocumentReady);
    
    /* 
        All functions to be called on $(document).ready() should be in this function
    */
    function mkdfOnDocumentReady() {
        mkdfInitQuantityButtons();
        mkdfInitSelect2();
	    mkdfInitSingleProductLightbox();
	    mkdfShopAnimate();
	    mkdfShopRelatedAnimate();
    }
	
    /*
    ** Init quantity buttons to increase/decrease products for cart
    */
	function mkdfInitQuantityButtons() {
		$(document).on('click', '.mkdf-quantity-minus, .mkdf-quantity-plus', function (e) {
			e.stopPropagation();
			
			var button = $(this),
				inputField = button.siblings('.mkdf-quantity-input'),
				step = parseFloat(inputField.data('step')),
				max = parseFloat(inputField.data('max')),
				minus = false,
				inputValue = parseFloat(inputField.val()),
				newInputValue;
			
			if (button.hasClass('mkdf-quantity-minus')) {
				minus = true;
			}
			
			if (minus) {
				newInputValue = inputValue - step;
				if (newInputValue >= 1) {
					inputField.val(newInputValue);
				} else {
					inputField.val(0);
				}
			} else {
				newInputValue = inputValue + step;
				if (max === undefined) {
					inputField.val(newInputValue);
				} else {
					if (newInputValue >= max) {
						inputField.val(max);
					} else {
						inputField.val(newInputValue);
					}
				}
			}
			
			inputField.trigger('change');
		});
	}
	/**
     * Initializes shop item appeared
     */
    var ShopListAnimation = function() {
       var items = $("mkdf-pl-main-holder type-product"),
        itemDelayCounter = 0;

       if (items.length) {
        items.each(function() {
         itemDelayCounter+=0.3;
         $(this).css({'transition': 'all .4s ' + itemDelayCounter + 's'});
        });
       }
    }
    
    ShopListAnimation();

    function mkdfShopAnimate() {
        var ItemsAnimate = $('.mkdf-pl-main-holder');
        if (ItemsAnimate.length) {
            ItemsAnimate.each(function () {
                var shopListShortcode = $(this);
                if (shopListShortcode.hasClass('mkdf-pl-main-holder')) {
                
                    var ItemAnimate = shopListShortcode.find('.type-product');

                   shopListShortcode.appear(function () {
                        shopListShortcode.addClass('mkdf-appeared');
                        setTimeout(function () {
                            ItemAnimate.each(function (i) {
                                var shopItem = $(this);
                                setTimeout(function () {
                                    shopItem.addClass('mkdf-appeared');
                                }, 250 * i);
                            });
                        }, 250);
                       
                    }, {accX: 0, accY: mkdfGlobalVars.vars.mkdfElementAppearAmount});

                }
            });
        }
    }

    /**
     * Initializes shop related item appeared
     */
    var ShopRelatedListAnimation = function() {
       var items = $("related type-product"),
        itemDelayCounter = 0;

       if (items.length) {
        items.each(function() {
         itemDelayCounter+=0.3;
         $(this).css({'transition': 'all .4s ' + itemDelayCounter + 's'});
        });
       }
    }
    
    ShopRelatedListAnimation();

    function mkdfShopRelatedAnimate() {
        var ItemsAnimate = $('.related');
        if (ItemsAnimate.length) {
            ItemsAnimate.each(function () {
                var shoprelatedListShortcode = $(this);
                if (shoprelatedListShortcode.hasClass('related')) {
                
                    var ItemAnimate = shoprelatedListShortcode.find('.type-product');

                   shoprelatedListShortcode.appear(function () {
                        shoprelatedListShortcode.addClass('mkdf-appeared');
                        setTimeout(function () {
                            ItemAnimate.each(function (i) {
                                var shoprelatedItem = $(this);
                                setTimeout(function () {
                                    shoprelatedItem.addClass('mkdf-appeared');
                                }, 250 * i);
                            });
                        }, 250);
                       
                    }, {accX: 0, accY: mkdfGlobalVars.vars.mkdfElementAppearAmount});

                }
            });
        }
    }
    /*
    ** Init select2 script for select html dropdowns
    */
	function mkdfInitSelect2() {
		var orderByDropDown = $('.woocommerce-ordering .orderby');
		if (orderByDropDown.length) {
			orderByDropDown.select2({
				minimumResultsForSearch: Infinity
			});
		}
		
		var variableProducts = $('.mkdf-woocommerce-page .mkdf-content .variations td.value select');
		if (variableProducts.length) {
			variableProducts.select2();
		}
		
		var shippingCountryCalc = $('#calc_shipping_country');
		if (shippingCountryCalc.length) {
			shippingCountryCalc.select2();
		}
		
		var shippingStateCalc = $('.cart-collaterals .shipping select#calc_shipping_state');
		if (shippingStateCalc.length) {
			shippingStateCalc.select2();
		}
	}
	
	/*
	 ** Init Product Single Pretty Photo attributes
	 */
	function mkdfInitSingleProductLightbox() {
		var item = $('.mkdf-woo-single-page.mkdf-woo-single-has-pretty-photo .images .woocommerce-product-gallery__image');
		
		if(item.length) {
			item.children('a').attr('data-rel', 'prettyPhoto[woo_single_pretty_photo]');
			
			if (typeof mkdf.modules.common.mkdfPrettyPhoto === "function") {
				mkdf.modules.common.mkdfPrettyPhoto();
			}
		}
	}

})(jQuery);