<?php

if ( class_exists( 'BoostUpCoreClassWidget' ) ) {
	class BoostUpMikadoClassSeparatorWidget extends BoostUpCoreClassWidget
	{
		public function __construct()
		{
			parent::__construct(
				'mkdf_separator_widget',
				esc_html__('BoostUp Separator Widget', 'boostup'),
				array('description' => esc_html__('Add a separator element to your widget areas', 'boostup'))
			);

			$this->setParams();
		}

		protected function setParams()
		{
			$this->params = array(
				array(
					'type' => 'dropdown',
					'name' => 'type',
					'title' => esc_html__('Type', 'boostup'),
					'options' => array(
						'normal' => esc_html__('Normal', 'boostup'),
						'full-width' => esc_html__('Full Width', 'boostup')
					)
				),
				array(
					'type' => 'dropdown',
					'name' => 'position',
					'title' => esc_html__('Position', 'boostup'),
					'options' => array(
						'center' => esc_html__('Center', 'boostup'),
						'left' => esc_html__('Left', 'boostup'),
						'right' => esc_html__('Right', 'boostup')
					)
				),
				array(
					'type' => 'dropdown',
					'name' => 'border_style',
					'title' => esc_html__('Style', 'boostup'),
					'options' => array(
						'solid' => esc_html__('Solid', 'boostup'),
						'dashed' => esc_html__('Dashed', 'boostup'),
						'dotted' => esc_html__('Dotted', 'boostup')
					)
				),
				array(
					'type' => 'colorpicker',
					'name' => 'color',
					'title' => esc_html__('Color', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'width',
					'title' => esc_html__('Width (px or %)', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'thickness',
					'title' => esc_html__('Thickness (px)', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'top_margin',
					'title' => esc_html__('Top Margin (px or %)', 'boostup')
				),
				array(
					'type' => 'textfield',
					'name' => 'bottom_margin',
					'title' => esc_html__('Bottom Margin (px or %)', 'boostup')
				)
			);
		}

		public function widget($args, $instance)
		{
			if (!is_array($instance)) {
				$instance = array();
			}

			//prepare variables
			$params = '';

			//is instance empty?
			if (is_array($instance) && count($instance)) {
				//generate shortcode params
				foreach ($instance as $key => $value) {
					$params .= " $key='$value' ";
				}
			}

			echo '<div class="widget mkdf-separator-widget">';
			echo do_shortcode("[mkdf_separator $params]"); // XSS OK
			echo '</div>';
		}
	}
}