<?php

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
if ( function_exists( 'vc_set_as_theme' ) ) {
	vc_set_as_theme( true );
}

/**
 * Change path for overridden templates
 */
if ( function_exists( 'vc_set_shortcodes_templates_dir' ) ) {
	$dir = MIKADO_ROOT_DIR . '/vc-templates';
	vc_set_shortcodes_templates_dir( $dir );
}

if ( ! function_exists( 'boostup_mikado_configure_visual_composer_frontend_editor' ) ) {
	/**
	 * Configuration for Visual Composer FrontEnd Editor
	 * Hooks on vc_after_init action
	 */
	function boostup_mikado_configure_visual_composer_frontend_editor() {
		/**
		 * Remove frontend editor
		 */
		if ( function_exists( 'vc_disable_frontend' ) ) {
			vc_disable_frontend();
		}
	}
	
	add_action( 'vc_after_init', 'boostup_mikado_configure_visual_composer_frontend_editor' );
}

if ( ! function_exists( 'boostup_mikado_vc_row_map' ) ) {
	/**
	 * Map VC Row shortcode
	 * Hooks on vc_after_init action
	 */
	function boostup_mikado_vc_row_map() {
		
		/******* VC Row shortcode - begin *******/
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'boostup' ),
				'value'      => array(
					esc_html__( 'Full Width', 'boostup' ) => 'full-width',
					esc_html__( 'In Grid', 'boostup' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'anchor',
				'heading'     => esc_html__( 'Mikado Anchor ID', 'boostup' ),
				'description' => esc_html__( 'For example "home"', 'boostup' ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'boostup' ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'boostup' ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'boostup' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'boostup' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'boostup' ),
				'value'       => array(
					esc_html__( 'Never', 'boostup' )        => '',
					esc_html__( 'Below 1280px', 'boostup' ) => '1280',
					esc_html__( 'Below 1024px', 'boostup' ) => '1024',
					esc_html__( 'Below 768px', 'boostup' )  => '768',
					esc_html__( 'Below 680px', 'boostup' )  => '680',
					esc_html__( 'Below 480px', 'boostup' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'boostup' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'attach_image',
				'param_name' => 'parallax_background_image',
				'heading'    => esc_html__( 'Mikado Parallax Background Image', 'boostup' ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'        => 'textfield',
				'param_name'  => 'parallax_bg_speed',
				'heading'     => esc_html__( 'Mikado Parallax Speed', 'boostup' ),
				'description' => esc_html__( 'Set your parallax speed. Default value is 1.', 'boostup' ),
				'dependency'  => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'textfield',
				'param_name' => 'parallax_bg_height',
				'heading'    => esc_html__( 'Mikado Parallax Section Height (px)', 'boostup' ),
				'dependency' => array( 'element' => 'parallax_background_image', 'not_empty' => true ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);


        vc_add_param( 'vc_row',
            array(
                'type'       => 'colorpicker',
                'param_name' => 'dynamic_background_color_value',
                'heading'    => esc_html__( 'Dynamic Background Color Value', 'boostup' ),
                'description' => esc_html__( 'This color value will be used if Dynamic Background Color metabox is set to Yes on this page.', 'boostup' ),
                'group'      => esc_html__( 'Mikado Settings', 'boostup' )
            )
        );
		
		vc_add_param( 'vc_row',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'boostup' ),
				'value'      => array(
					esc_html__( 'Default', 'boostup' ) => '',
					esc_html__( 'Left', 'boostup' )    => 'left',
					esc_html__( 'Center', 'boostup' )  => 'center',
					esc_html__( 'Right', 'boostup' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);

		do_action( 'boostup_mikado_action_additional_vc_row_params' );
		
		/******* VC Row shortcode - end *******/
		
		/******* VC Row Inner shortcode - begin *******/
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'row_content_width',
				'heading'    => esc_html__( 'Mikado Row Content Width', 'boostup' ),
				'value'      => array(
					esc_html__( 'Full Width', 'boostup' ) => 'full-width',
					esc_html__( 'In Grid', 'boostup' )    => 'grid'
				),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'colorpicker',
				'param_name' => 'simple_background_color',
				'heading'    => esc_html__( 'Mikado Background Color', 'boostup' ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'attach_image',
				'param_name' => 'simple_background_image',
				'heading'    => esc_html__( 'Mikado Background Image', 'boostup' ),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'textfield',
				'param_name'  => 'background_image_position',
				'heading'     => esc_html__( 'Mikado Background Position', 'boostup' ),
				'description' => esc_html__( 'Set the starting position of a background image, default value is top left', 'boostup' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'        => 'dropdown',
				'param_name'  => 'disable_background_image',
				'heading'     => esc_html__( 'Mikado Disable Background Image', 'boostup' ),
				'value'       => array(
					esc_html__( 'Never', 'boostup' )        => '',
					esc_html__( 'Below 1280px', 'boostup' ) => '1280',
					esc_html__( 'Below 1024px', 'boostup' ) => '1024',
					esc_html__( 'Below 768px', 'boostup' )  => '768',
					esc_html__( 'Below 680px', 'boostup' )  => '680',
					esc_html__( 'Below 480px', 'boostup' )  => '480'
				),
				'save_always' => true,
				'description' => esc_html__( 'Choose on which stage you hide row background image', 'boostup' ),
				'dependency'  => array( 'element' => 'simple_background_image', 'not_empty' => true ),
				'group'       => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		vc_add_param( 'vc_row_inner',
			array(
				'type'       => 'dropdown',
				'param_name' => 'content_text_aligment',
				'heading'    => esc_html__( 'Mikado Content Aligment', 'boostup' ),
				'value'      => array(
					esc_html__( 'Default', 'boostup' ) => '',
					esc_html__( 'Left', 'boostup' )    => 'left',
					esc_html__( 'Center', 'boostup' )  => 'center',
					esc_html__( 'Right', 'boostup' )   => 'right'
				),
				'group'      => esc_html__( 'Mikado Settings', 'boostup' )
			)
		);
		
		/******* VC Row Inner shortcode - end *******/
		
		/******* VC Revolution Slider shortcode - begin *******/
		
		if ( boostup_mikado_revolution_slider_installed() ) {
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'enable_paspartu',
					'heading'     => esc_html__( 'Mikado Enable Passepartout', 'boostup' ),
					'value'       => array_flip( boostup_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'group'       => esc_html__( 'Mikado Settings', 'boostup' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'paspartu_size',
					'heading'     => esc_html__( 'Mikado Passepartout Size', 'boostup' ),
					'value'       => array(
						esc_html__( 'Tiny', 'boostup' )   => 'tiny',
						esc_html__( 'Small', 'boostup' )  => 'small',
						esc_html__( 'Normal', 'boostup' ) => 'normal',
						esc_html__( 'Large', 'boostup' )  => 'large'
					),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'boostup' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_side_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Side Passepartout', 'boostup' ),
					'value'       => array_flip( boostup_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'boostup' )
				)
			);
			
			vc_add_param( 'rev_slider_vc',
				array(
					'type'        => 'dropdown',
					'param_name'  => 'disable_top_paspartu',
					'heading'     => esc_html__( 'Mikado Disable Top Passepartout', 'boostup' ),
					'value'       => array_flip( boostup_mikado_get_yes_no_select_array( false ) ),
					'save_always' => true,
					'dependency'  => array( 'element' => 'enable_paspartu', 'value' => array( 'yes' ) ),
					'group'       => esc_html__( 'Mikado Settings', 'boostup' )
				)
			);
			vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_1',
                    'heading'    => esc_html__( 'Background Text', 'boostup' ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size',
                    'heading'    => esc_html__( 'Background Text Size', 'boostup' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size_1440',
                    'heading'    => esc_html__( 'Background Text Size 1280px-1440px', 'boostup' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_size_1280',
                    'heading'    => esc_html__( 'Background Text Size 1024px-1280px', 'boostup' ),
                    'description' => esc_html__( 'Set the background text size in px or em', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'colorpicker',
                    'param_name' => 'row_background_text_color',
                    'heading'    => esc_html__( 'Background Text Color', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_align',
                    'heading'    => esc_html__( 'Background Text Align', 'boostup' ),
                    'value'      => array(
                        esc_html__( 'Default', 'boostup' ) => '',
                        esc_html__( 'Left', 'boostup' )    => 'left',
                        esc_html__( 'Center', 'boostup' )  => 'center',
                        esc_html__( 'Right', 'boostup' )   => 'right'
                    ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_vertical_align',
                    'heading'    => esc_html__( 'Background Vertical Align', 'boostup' ),
                    'value'      => array(
                        esc_html__( 'Middle', 'boostup' )   => 'middle',
                        esc_html__( 'Top', 'boostup' )      => 'top',
                        esc_html__( 'Bottom', 'boostup' )   => 'bottom'
                    ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_top',
                    'heading'    => esc_html__( 'Background Text Top Padding', 'boostup' ),
                    'description' => esc_html__( 'Set the value of top padding in px or %', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_left',
                    'heading'    => esc_html__( 'Background Text Left Padding', 'boostup' ),
                    'description' => esc_html__( 'Set the value of left padding in px or %', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_padding_right',
                    'heading'    => esc_html__( 'Background Text Right Padding', 'boostup' ),
                    'description' => esc_html__( 'Set the value of right padding in px or %', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'textfield',
                    'param_name' => 'row_background_text_margin_top',
                    'heading'    => esc_html__( 'Background Text Top Margin', 'boostup' ),
                    'description' => esc_html__( 'Set the value of top margin in px or %', 'boostup' ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );

            vc_add_param( 'vc_row',
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'row_background_text_animation',
                    'heading'    => esc_html__( 'Animate Background Text', 'boostup' ),
                    'value'      => array_flip( boostup_mikado_get_yes_no_select_array(false, true) ),
                    'dependency' => array( 'element' => 'row_background_text_1', 'not_empty' => true ),
                    'description'    => esc_html__( 'Animate background text when row appears in viewport', 'boostup' ),
                    'group'      => esc_html__( 'Mikado Settings', 'boostup' )
                )
            );
		}
		
		/******* VC Revolution Slider shortcode - end *******/
	}
	
	add_action( 'vc_after_init', 'boostup_mikado_vc_row_map' );
}