<?php

if ( ! function_exists( 'boostup_mikado_map_sidebar_meta' ) ) {
	function boostup_mikado_map_sidebar_meta() {
		$mkdf_sidebar_meta_box = boostup_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'boostup_mikado_filter_set_scope_for_meta_boxes', array( 'page' ), 'sidebar_meta' ),
				'title' => esc_html__( 'Sidebar', 'boostup' ),
				'name'  => 'sidebar_meta'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_sidebar_layout_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Sidebar Layout', 'boostup' ),
				'description' => esc_html__( 'Choose the sidebar layout', 'boostup' ),
				'parent'      => $mkdf_sidebar_meta_box,
                'options'       => boostup_mikado_get_custom_sidebars_options( true )
			)
		);
		
		$mkdf_custom_sidebars = boostup_mikado_get_custom_sidebars();
		if ( count( $mkdf_custom_sidebars ) > 0 ) {
			boostup_mikado_create_meta_box_field(
				array(
					'name'        => 'mkdf_custom_sidebar_area_meta',
					'type'        => 'selectblank',
					'label'       => esc_html__( 'Choose Widget Area in Sidebar', 'boostup' ),
					'description' => esc_html__( 'Choose Custom Widget area to display in Sidebar"', 'boostup' ),
					'parent'      => $mkdf_sidebar_meta_box,
					'options'     => $mkdf_custom_sidebars,
					'args'        => array(
						'select2' => true
					)
				)
			);
		}
	}
	
	add_action( 'boostup_mikado_action_meta_boxes_map', 'boostup_mikado_map_sidebar_meta', 31 );
}