<?php

if ( ! function_exists( 'boostup_mikado_get_hide_dep_for_header_sticky_area_meta_boxes' ) ) {
    function boostup_mikado_get_hide_dep_for_header_sticky_area_meta_boxes() {
        $hide_dep_options = apply_filters( 'boostup_mikado_filter_header_sticky_area_hide_meta_boxes', $hide_dep_options = array() );

        return $hide_dep_options;
    }
}

if ( ! function_exists( 'boostup_mikado_header_sticky_area_meta_options_map' ) ) {
    function boostup_mikado_header_sticky_area_meta_options_map( $header_meta_box ) {
        $hide_dep_options = boostup_mikado_get_hide_dep_for_header_sticky_area_meta_boxes();

        $sticky_area_container = boostup_mikado_add_admin_container_no_style(
            array(
                'type'       => 'container',
                'name'       => 'sticky_area_container',
                'parent'     => $header_meta_box,
                'dependency' => array(
                    'hide' => array(
                        'mkdf_header_type_meta' => $hide_dep_options
                    )
                ),
                'args'       => array(
                    'enable_panels_for_default_value' => true
                )
            )
        );

        boostup_mikado_add_admin_section_title(
            array(
                'parent' => $sticky_area_container,
                'name'   => 'sticky_area_style',
                'title'  => esc_html__( 'Sticky Area Style', 'boostup' )
            )
        );

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_sticky_area_background_color_meta',
                'type'        => 'color',
                'label'       => esc_html__( 'Background Color', 'boostup' ),
                'description' => esc_html__( 'Choose a background color for Sticky Area', 'boostup' ),
                'parent'      => $sticky_area_container
            )
        );

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_sticky_area_background_transparency_meta',
                'type'        => 'text',
                'label'       => esc_html__( 'Transparency', 'boostup' ),
                'description' => esc_html__( 'Choose a transparency for the Sticky Area background color (0 = fully transparent, 1 = opaque)', 'boostup' ),
                'parent'      => $sticky_area_container,
                'args'        => array(
                    'col_width' => 2
                )
            )
        );

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_sticky_area_menu_item_color',
                'type'        => 'color',
                'label'       => esc_html__( 'Sticky Menu Item Color', 'boostup' ),
                'description' => esc_html__( 'Choose a background color for sticky menu item', 'boostup' ),
                'parent'      => $sticky_area_container
            )
        );

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_sticky_area_menu_active_and_hover_item_color',
                'type'        => 'color',
                'label'       => esc_html__( 'Sticky Menu Active and Hover Item Color', 'boostup' ),
                'description' => esc_html__( 'Choose a background color for sticky menu active and hover item', 'boostup' ),
                'parent'      => $sticky_area_container
            )
        );

        do_action( 'boostup_mikado_header_sticky_area_additional_meta_boxes_map', $sticky_area_container );
    }

    add_action( 'boostup_mikado_action_header_sticky_area_meta_boxes_map', 'boostup_mikado_header_sticky_area_meta_options_map', 10, 1 );
}