<?php

if ( ! function_exists( 'boostup_mikado_footer_options_map' ) ) {
	function boostup_mikado_footer_options_map() {

		boostup_mikado_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'boostup' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = boostup_mikado_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'boostup' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		boostup_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'boostup' ),
				'parent'        => $footer_panel
			)
		);

        boostup_mikado_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'boostup' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'boostup' ),
                'parent'        => $footer_panel
            )
        );

		boostup_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'boostup' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = boostup_mikado_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		


		boostup_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'boostup' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'boostup' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		boostup_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'boostup' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'boostup' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'boostup' ),
					'left'   => esc_html__( 'Left', 'boostup' ),
					'center' => esc_html__( 'Center', 'boostup' ),
					'right'  => esc_html__( 'Right', 'boostup' )
				),
				'parent'        => $show_footer_top_container
			)
		);
		
		$footer_top_styles_group = boostup_mikado_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'boostup' ),
				'description' => esc_html__( 'Define style for footer top area', 'boostup' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = boostup_mikado_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'boostup' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'boostup' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'boostup' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		boostup_mikado_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'boostup' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = boostup_mikado_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		boostup_mikado_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '12',
				'label'         => esc_html__( 'Footer Bottom Columns', 'boostup' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'boostup' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_group = boostup_mikado_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'boostup' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'boostup' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = boostup_mikado_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'boostup' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'boostup' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			boostup_mikado_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'boostup' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'boostup_mikado_action_options_map', 'boostup_mikado_footer_options_map', boostup_mikado_set_options_map_position( 'footer' ) );
}