<?php

if ( ! function_exists( 'boostup_mikado_map_footer_meta' ) ) {
	function boostup_mikado_map_footer_meta() {
		
		$footer_meta_box = boostup_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'boostup_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'footer_meta' ),
				'title' => esc_html__( 'Footer', 'boostup' ),
				'name'  => 'footer_meta'
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_disable_footer_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Disable Footer For This Page', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will hide footer on this page', 'boostup' ),
				'options'       => boostup_mikado_get_yes_no_select_array(),
				'parent'        => $footer_meta_box
			)
		);
		
		$show_footer_meta_container = boostup_mikado_add_admin_container(
			array(
				'name'       => 'mkdf_show_footer_meta_container',
				'parent'     => $footer_meta_box,
				'dependency' => array(
					'hide' => array(
						'mkdf_disable_footer_meta' => 'yes'
					)
				)
			)
		);
		
			boostup_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_footer_in_grid_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Footer in Grid', 'boostup' ),
					'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'boostup' ),
					'options'       => boostup_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			
			boostup_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_uncovering_footer_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Uncovering Footer', 'boostup' ),
					'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'boostup' ),
					'options'       => boostup_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			boostup_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_show_footer_top_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Top', 'boostup' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'boostup' ),
					'options'       => boostup_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
			

			boostup_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_footer_skin_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Footer Skin', 'boostup' ),
					'description'   => esc_html__( 'Choose a footer style to make footer elements (logo, text, links) in that predefined style', 'boostup' ),
					'parent'        => $show_footer_meta_container,
					'options'       => array(
						''             => esc_html__( 'Default', 'boostup' ),
						'light' => esc_html__( 'Light', 'boostup' ),
						'dark'  => esc_html__( 'Dark', 'boostup' )
					)
				)
			);
		
			$footer_top_styles_group = boostup_mikado_add_admin_group(
				array(
					'name'        => 'footer_top_styles_group',
					'title'       => esc_html__( 'Footer Top Styles', 'boostup' ),
					'description' => esc_html__( 'Define style for footer top area', 'boostup' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'hide' => array(
							'mkdf_show_footer_top_meta' => 'no'
						)
					)
				)
			);
			
			$footer_top_styles_row_1 = boostup_mikado_add_admin_row(
				array(
					'name'   => 'footer_top_styles_row_1',
					'parent' => $footer_top_styles_group
				)
			);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'boostup' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'boostup' ),
						'parent' => $footer_top_styles_row_1
					)
				);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_top_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'boostup' ),
						'parent' => $footer_top_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);
			
			boostup_mikado_create_meta_box_field(
				array(
					'name'          => 'mkdf_show_footer_bottom_meta',
					'type'          => 'select',
					'default_value' => '',
					'label'         => esc_html__( 'Show Footer Bottom', 'boostup' ),
					'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'boostup' ),
					'options'       => boostup_mikado_get_yes_no_select_array(),
					'parent'        => $show_footer_meta_container
				)
			);
		
			$footer_bottom_styles_group = boostup_mikado_add_admin_group(
				array(
					'name'        => 'footer_bottom_styles_group',
					'title'       => esc_html__( 'Footer Bottom Styles', 'boostup' ),
					'description' => esc_html__( 'Define style for footer bottom area', 'boostup' ),
					'parent'      => $show_footer_meta_container,
					'dependency'  => array(
						'hide' => array(
							'mkdf_show_footer_bottom_meta' => 'no'
						)
					)
				)
			);
			
			$footer_bottom_styles_row_1 = boostup_mikado_add_admin_row(
				array(
					'name'   => 'footer_bottom_styles_row_1',
					'parent' => $footer_bottom_styles_group
				)
			);
			
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_background_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Background Color', 'boostup' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_border_color_meta',
						'type'   => 'colorsimple',
						'label'  => esc_html__( 'Border Color', 'boostup' ),
						'parent' => $footer_bottom_styles_row_1
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_footer_bottom_border_width_meta',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Border Width', 'boostup' ),
						'parent' => $footer_bottom_styles_row_1,
						'args'   => array(
							'suffix' => 'px'
						)
					)
				);

        $boostup_custom_sidebars = boostup_mikado_get_custom_sidebars();
        if ( count( $boostup_custom_sidebars ) > 0 ) {
            boostup_mikado_create_meta_box_field(
                array(
                    'name'        => 'mkdf_custom_footer_widget_area_one_meta',
                    'type'        => 'selectblank',
                    'label'       => esc_html__( 'Choose Custom footer Widget Area One', 'boostup' ),
                    'description' => esc_html__( 'Choose custom widget area to display in footer widget area one', 'boostup' ),
                    'parent'      => $footer_meta_box,
                    'options'     => $boostup_custom_sidebars
                )
            );
        }
	}
	
	add_action( 'boostup_mikado_action_meta_boxes_map', 'boostup_mikado_map_footer_meta', 70 );
}






