<?php

if ( ! function_exists( 'boostup_mikado_footer_top_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer top area
	 */
	function boostup_mikado_footer_top_general_styles() {
		$item_styles      = array();
		$background_color = boostup_mikado_options()->getOptionValue( 'footer_top_background_color' );
		$border_color     = boostup_mikado_options()->getOptionValue( 'footer_top_border_color' );
		$border_width     = boostup_mikado_options()->getOptionValue( 'footer_top_border_width' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		if ( ! empty( $border_color ) ) {
			$item_styles['border-color'] = $border_color;
			
			if ( $border_width === '' ) {
				$item_styles['border-width'] = '1px';
			}
		}
		
		if ( $border_width !== '' ) {
			$item_styles['border-width'] = boostup_mikado_filter_px( $border_width ) . 'px';
		}
		
		echo boostup_mikado_dynamic_css( '.mkdf-page-footer .mkdf-footer-top-holder', $item_styles );
	}
	
	add_action( 'boostup_mikado_action_style_dynamic', 'boostup_mikado_footer_top_general_styles' );
}

if ( ! function_exists( 'boostup_mikado_footer_bottom_general_styles' ) ) {
	/**
	 * Generates general custom styles for footer bottom area
	 */
	function boostup_mikado_footer_bottom_general_styles() {
		$item_styles      = array();
		$item_styles2     = array();
		$background_color = boostup_mikado_options()->getOptionValue( 'footer_bottom_background_color' );
		$border_color     = boostup_mikado_options()->getOptionValue( 'footer_bottom_border_color' );
		$border_width     = boostup_mikado_options()->getOptionValue( 'footer_bottom_border_width' );
		
		if ( ! empty( $background_color ) ) {
			$item_styles['background-color'] = $background_color;
		}
		
		if ( ! empty( $border_color ) ) {
			$item_styles2['border-color'] = $border_color;
			
			if ( $border_width === '' ) {
				$item_styles2['border-width'] = '1px';
			}
		}
		
		if ( $border_width !== '' ) {
			$item_styles2['border-width'] = boostup_mikado_filter_px( $border_width ) . 'px';
		}
		
		echo boostup_mikado_dynamic_css( '.mkdf-page-footer .mkdf-footer-bottom-holder', $item_styles );
		echo boostup_mikado_dynamic_css( '.mkdf-page-footer .mkdf-footer-bottom-holder .mkdf-footer-bottom-inner', $item_styles2 );
	}

	add_action( 'boostup_mikado_action_style_dynamic', 'boostup_mikado_footer_bottom_general_styles' );
}