<?php

if ( ! function_exists( 'boostup_mikado_map_general_meta' ) ) {
	function boostup_mikado_map_general_meta() {
		
		$general_meta_box = boostup_mikado_create_meta_box(
			array(
				'scope' => apply_filters( 'boostup_mikado_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'boostup' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'boostup' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'boostup' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'boostup' ),
				'parent'        => $general_meta_box
			)
		);
		
		$mkdf_content_padding_group = boostup_mikado_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Styles', 'boostup' ),
				'description' => esc_html__( 'Define styles for Content area', 'boostup' ),
				'parent'      => $general_meta_box
			)
		);
		
			$mkdf_content_padding_row = boostup_mikado_add_admin_row(
				array(
					'name'   => 'mkdf_content_padding_row',
					'parent' => $mkdf_content_padding_group
				)
			);
			
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_background_color_meta',
						'type'        => 'colorsimple',
						'label'       => esc_html__( 'Page Background Color', 'boostup' ),
						'parent'      => $mkdf_content_padding_row
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_page_background_image_meta',
						'type'          => 'imagesimple',
						'label'         => esc_html__( 'Page Background Image', 'boostup' ),
						'parent'        => $mkdf_content_padding_row
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_page_background_repeat_meta',
						'type'          => 'selectsimple',
						'default_value' => '',
						'label'         => esc_html__( 'Page Background Image Repeat', 'boostup' ),
						'options'       => boostup_mikado_get_yes_no_select_array(),
						'parent'        => $mkdf_content_padding_row
					)
				);
		
			$mkdf_content_padding_row_1 = boostup_mikado_add_admin_row(
				array(
					'name'   => 'mkdf_content_padding_row_1',
					'next'   => true,
					'parent' => $mkdf_content_padding_group
				)
			);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'   => 'mkdf_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (eg. 10px 5px 10px 5px)', 'boostup' ),
						'parent' => $mkdf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'    => 'mkdf_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (eg. 10px 5px 10px 5px)', 'boostup' ),
						'parent'  => $mkdf_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_page_dynamic_background_color',
                'type'        => 'yesno',
                'default_value' => 'no',
                'label'       => esc_html__( 'Dynamic Background Color', 'boostup' ),
                'description' => esc_html__( 'Background color will change depending on the value set on the corresponding Row element - currently in viewport.', 'boostup' ),
                'parent'      => $general_meta_box
            )
        );
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'boostup' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'boostup' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'boostup' ),
					'mkdf-grid-1300' => esc_html__( '1300px', 'boostup' ),
					'mkdf-grid-1200' => esc_html__( '1200px', 'boostup' ),
					'mkdf-grid-1100' => esc_html__( '1100px', 'boostup' ),
					'mkdf-grid-1000' => esc_html__( '1000px', 'boostup' ),
					'mkdf-grid-800'  => esc_html__( '800px', 'boostup' )
				)
			)
		);
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_grid_space_meta',
				'type'        => 'select',
				'default_value' => '',
				'label'       => esc_html__( 'Grid Layout Space', 'boostup' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for your page', 'boostup' ),
				'options'     => boostup_mikado_get_space_between_items_array( true ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'    => 'mkdf_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'boostup' ),
				'parent'  => $general_meta_box,
				'options' => boostup_mikado_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = boostup_mikado_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_boxed_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'boostup' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'boostup' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'boostup' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'boostup' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'boostup' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'boostup' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'          => 'mkdf_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'boostup' ),
						'description'   => esc_html__( 'Choose background image attachment', 'boostup' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'boostup' ),
							'fixed'  => esc_html__( 'Fixed', 'boostup' ),
							'scroll' => esc_html__( 'Scroll', 'boostup' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'boostup' ),
				'parent'        => $general_meta_box,
				'options'       => boostup_mikado_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = boostup_mikado_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'mkdf_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'boostup' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'boostup' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'boostup' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'boostup' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'boostup' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'boostup' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				boostup_mikado_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'mkdf_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'boostup' ),
						'options'       => boostup_mikado_get_yes_no_select_array(),
					)
				);
		
				boostup_mikado_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'mkdf_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'boostup' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'boostup' ),
						'options'       => boostup_mikado_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'          => 'mkdf_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'boostup' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'boostup' ),
				'parent'        => $general_meta_box,
				'options'       => boostup_mikado_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = boostup_mikado_add_admin_container(
				array(
					'parent'     => $general_meta_box,
					'name'       => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'mkdf_smooth_page_transitions_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				boostup_mikado_create_meta_box_field(
					array(
						'name'        => 'mkdf_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'boostup' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'boostup' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => boostup_mikado_get_yes_no_select_array()
					)
				);
		
				$page_transition_preloader_container_meta = boostup_mikado_add_admin_container(
					array(
						'parent'     => $page_transitions_container_meta,
						'name'       => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'mkdf_page_transition_preloader_meta' => array( '', 'no' )
							)
						)
					)
				);
				
					boostup_mikado_create_meta_box_field(
						array(
							'name'   => 'mkdf_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'boostup' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = boostup_mikado_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'boostup' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'boostup' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = boostup_mikado_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					boostup_mikado_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'mkdf_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'boostup' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'boostup' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'boostup' ),
								'pulse'                 => esc_html__( 'Pulse', 'boostup' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'boostup' ),
								'cube'                  => esc_html__( 'Cube', 'boostup' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'boostup' ),
								'stripes'               => esc_html__( 'Stripes', 'boostup' ),
								'wave'                  => esc_html__( 'Wave', 'boostup' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'boostup' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'boostup' ),
								'atom'                  => esc_html__( 'Atom', 'boostup' ),
								'clock'                 => esc_html__( 'Clock', 'boostup' ),
								'mitosis'               => esc_html__( 'Mitosis', 'boostup' ),
								'lines'                 => esc_html__( 'Lines', 'boostup' ),
								'fussion'               => esc_html__( 'Fussion', 'boostup' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'boostup' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'boostup' ),
								'pulse_boost'          => esc_html__( 'Pulse Boost Up', 'boostup' )
							)
						)
					);
					
					boostup_mikado_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'mkdf_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'boostup' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					boostup_mikado_create_meta_box_field(
						array(
							'name'        => 'mkdf_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'boostup' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'boostup' ),
							'options'     => boostup_mikado_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		boostup_mikado_create_meta_box_field(
			array(
				'name'        => 'mkdf_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'boostup' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'boostup' ),
				'parent'      => $general_meta_box,
				'options'     => boostup_mikado_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/

        /***************** main color - begin **********************/

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_first_color_meta',
                'type'        => 'color',
                'label'       => esc_html__( 'Page Main Color', 'boostup' ),
                'description' => esc_html__( 'Choose main color on this page for most elements', 'boostup' ),
                'parent'      => $general_meta_box,
            )
        );

        /***************** main color - end **********************/

        /***************** SVG Back toi top - begin **********************/

        boostup_mikado_create_meta_box_field(
            array(
                'name'        => 'mkdf_page_svg_back',
                'type'        => 'color',
                'label'       => esc_html__( 'SVG Back to top color', 'boostup' ),
                'description' => esc_html__( 'Choose color for SVG fill of back to top color, default value is #ffffff', 'boostup' ),
                'parent'      => $general_meta_box,
            )
        );

        /***************** SVG back to top - end **********************/
	}
	
	add_action( 'boostup_mikado_action_meta_boxes_map', 'boostup_mikado_map_general_meta', 10 );
}

if ( ! function_exists( 'boostup_mikado_container_background_style' ) ) {
	/**
	 * Function that return container style
	 */
	function boostup_mikado_container_background_style( $style ) {
		$page_id      = boostup_mikado_get_page_id();
		$class_prefix = boostup_mikado_get_unique_page_class( $page_id, true );
		
		$container_selector = array(
			$class_prefix . ' .mkdf-content'
		);
		
		$container_class        = array();
		$page_background_color  = get_post_meta( $page_id, 'mkdf_page_background_color_meta', true );
		$page_background_image  = get_post_meta( $page_id, 'mkdf_page_background_image_meta', true );
		$page_background_repeat = get_post_meta( $page_id, 'mkdf_page_background_repeat_meta', true );
		
		if ( ! empty( $page_background_color ) ) {
			$container_class['background-color'] = $page_background_color;
		}
		
		if ( ! empty( $page_background_image ) ) {
			$container_class['background-image'] = 'url(' . esc_url( $page_background_image ) . ')';
			
			if ( $page_background_repeat === 'yes' ) {
				$container_class['background-repeat']   = 'repeat';
				$container_class['background-position'] = '0 0';
			} else {
				$container_class['background-repeat']   = 'no-repeat';
				$container_class['background-position'] = 'center 0';
				$container_class['background-size']     = 'cover';
			}
		}
		
		$current_style = boostup_mikado_dynamic_css( $container_selector, $container_class );
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'boostup_mikado_filter_add_page_custom_style', 'boostup_mikado_container_background_style' );
}

if ( ! function_exists( 'boostup_mikado_main_color' ) ) {

    function boostup_mikado_main_color( $style ) {
        $page_id            = boostup_mikado_get_page_id();
        $class_prefix       = boostup_mikado_get_unique_page_class( $page_id, true );
        $first_main_color   = get_post_meta( $page_id, 'mkdf_first_color_meta', true );
        $temp_style = '';

        if ( ! empty( $first_main_color ) ) {
            $color_selector = $color_important_selector = $background_color_selector = $background_color_important_selector = $border_color_selector = $border_color_important_selector = $fill_color_selector = $fill_color_important_selector = $stroke_color_selector = $stroke_color_important_selector = array();

            // Include first main color selectors
            include_once MIKADO_ASSETS_ROOT_DIR . '/custom-styles/parts/first-main-color.php';

            if ( boostup_mikado_is_woocommerce_installed() ) {
                $woo_color_selector = $woo_color_important_selector = $woo_background_color_selector = $woo_background_color_important_selector = $woo_border_color_selector = $woo_border_color_important_selector = $woo_fill_color_selector = $woo_fill_color_important_selector = $woo_stroke_color_selector = $woo_stroke_color_important_selector = array();

                // Include first main color WooCommerce selectors
                include_once MIKADO_ASSETS_ROOT_DIR . '/custom-styles/parts/woocommerce-first-main-color.php';

                if ( isset( $woo_color_selector ) && ! empty( $woo_color_selector ) ) {
                    $color_selector = array_merge( $color_selector, $woo_color_selector );
                }

                if ( isset( $woo_color_important_selector ) && ! empty( $woo_color_important_selector ) ) {
                    $color_important_selector = array_merge( $color_important_selector, $woo_color_important_selector );
                }

                if ( isset( $woo_background_color_selector ) && ! empty( $woo_background_color_selector ) ) {
                    $background_color_selector = array_merge( $background_color_selector, $woo_background_color_selector );
                }

                if ( isset( $woo_background_color_important_selector ) && ! empty( $woo_background_color_important_selector ) ) {
                    $background_color_important_selector = array_merge( $background_color_important_selector, $woo_background_color_important_selector );
                }

                if ( isset( $woo_border_color_selector ) && ! empty( $woo_border_color_selector ) ) {
                    $border_color_selector = array_merge( $border_color_selector, $woo_border_color_selector );
                }

                if ( isset( $woo_border_color_important_selector ) && ! empty( $woo_border_color_important_selector ) ) {
                    $border_color_important_selector = array_merge( $border_color_important_selector, $woo_border_color_important_selector );
                }

                if ( isset( $woo_fill_color_selector ) && ! empty( $woo_fill_color_selector ) ) {
                    $fill_color_selector = array_merge( $fill_color_selector, $woo_fill_color_selector );
                }

                if ( isset( $woo_fill_color_important_selector ) && ! empty( $woo_fill_color_important_selector ) ) {
                    $fill_color_important_selector = array_merge( $fill_color_important_selector, $woo_fill_color_important_selector );
                }

                if ( isset( $woo_stroke_color_selector ) && ! empty( $woo_stroke_color_selector ) ) {
                    $stroke_color_selector = array_merge( $stroke_color_selector, $woo_stroke_color_selector );
                }

                if ( isset( $woo_stroke_color_important_selector ) && ! empty( $woo_stroke_color_important_selector ) ) {
                    $stroke_color_important_selector = array_merge( $stroke_color_important_selector, $woo_stroke_color_important_selector );
                }
            }

            if ( isset( $color_selector ) && ! empty( $color_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $color_selector, array( 'color' => $first_main_color ) );
            }

            if ( isset( $color_important_selector ) && ! empty( $color_important_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $color_important_selector, array( 'color' => $first_main_color . '!important' ) );
            }

            if ( isset( $background_color_selector ) && ! empty( $background_color_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $background_color_selector, array( 'background-color' => $first_main_color ) );
            }

            if ( isset( $background_color_important_selector ) && ! empty( $background_color_important_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $background_color_important_selector, array( 'background-color' => $first_main_color . '!important' ) );
            }

            if ( isset( $border_color_selector ) && ! empty( $border_color_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $border_color_selector, array( 'border-color' => $first_main_color ) );
            }

            if ( isset( $border_color_important_selector ) && ! empty( $border_color_important_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $border_color_important_selector, array( 'border-color' => $first_main_color . '!important' ) );
            }

            if ( isset( $fill_color_selector ) && ! empty( $fill_color_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $fill_color_selector, array( 'fill' => $first_main_color ) );
            }

            if ( isset( $fill_color_important_selector ) && ! empty( $fill_color_important_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $fill_color_important_selector, array( 'fill' => $first_main_color . '!important' ) );
            }

            if ( isset( $stroke_color_selector ) && ! empty( $stroke_color_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $stroke_color_selector, array( 'stroke' => $first_main_color ) );
            }

            if ( isset( $stroke_color_important_selector ) && ! empty( $stroke_color_important_selector ) ) {
                $temp_style .= boostup_mikado_dynamic_css( $stroke_color_important_selector, array( 'stroke' => $first_main_color . '!important' ) );
            }
        }

        $current_style = $temp_style . $style;

        return $current_style;
    }

    add_filter( 'boostup_mikado_filter_add_page_custom_style', 'boostup_mikado_main_color' );
}

if ( ! function_exists( 'boostup_mikado_svg_back_style' ) ) {

    function boostup_mikado_svg_back_style( $style ) {
        $page_id      = boostup_mikado_get_page_id();
        $class_prefix = boostup_mikado_get_unique_page_class( $page_id, true );

        $svg_selector = array(
            $class_prefix . ' #mkdf-back-to-top svg path'
        );

        $svg_class        = array();
        $svg_fill_color  = get_post_meta( $page_id, 'mkdf_page_svg_back', true );

        if ( ! empty( $svg_fill_color ) ) {
            $svg_class['fill'] = $svg_fill_color;
        }

        $current_style = boostup_mikado_dynamic_css( $svg_selector, $svg_class );
        $current_style = $current_style . $style;

        return $current_style;
    }

    add_filter( 'boostup_mikado_filter_add_page_custom_style', 'boostup_mikado_svg_back_style' );
}