<?php get_header(); ?>
<div class="mkdf-page-not-found">
	<?php
	$mkdf_title_image_404 = boostup_mikado_options()->getOptionValue('404_page_title_image');
	$mkdf_title_404 = boostup_mikado_options()->getOptionValue('404_title');
	$mkdf_subtitle_404 = boostup_mikado_options()->getOptionValue('404_subtitle');
	$mkdf_text_404 = boostup_mikado_options()->getOptionValue('404_text');
	$mkdf_button_label = boostup_mikado_options()->getOptionValue('404_back_to_home');
	$mkdf_button_style = boostup_mikado_options()->getOptionValue('404_button_style');
	$mkdf_button_popup = boostup_mikado_options()->getOptionValue('404_button_style');

	if (!empty($mkdf_title_image_404)) { ?>
		<div class="mkdf-404-title-image">
			<img src="<?php echo esc_url($mkdf_title_image_404); ?>"
				 alt="<?php esc_attr_e('404 Title Image', 'boostup'); ?>"/>
		</div>
	<?php } ?>

	<h1 class="mkdf-404-title">
		<?php if (!empty($mkdf_title_404)) {
			echo esc_html($mkdf_title_404);
		} else {
			esc_html_e('404', 'boostup');
		} ?>
	</h1>

	<h3 class="mkdf-404-subtitle">
		<?php if (!empty($mkdf_subtitle_404)) {
			echo esc_html($mkdf_subtitle_404);
		} else {
			esc_html_e('Page not found', 'boostup');
		} ?>
	</h3>

	<p class="mkdf-404-text">
		<?php if (!empty($mkdf_text_404)) {
			echo esc_html($mkdf_text_404);
		} else {
			esc_html_e('Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'boostup');
		} ?>
	</p>

	<?php

	if ($mkdf_button_style == 'light-style') {
		$button_params['custom_class'] = 'mkdf-btn-light-style';
	}

	if (boostup_mikado_core_plugin_installed()) {
		echo boostup_mikado_get_button_html(array(
			'link' => esc_url(home_url('/')),
			'size' => 'huge',
			'popup' => 'no',
			'text' => !empty($mkdf_button_label) ? $mkdf_button_label : esc_html__('Back to home', 'boostup')
		));
	} else {
		echo '<a itemprop="url" href="'. esc_url(home_url('/')) .'" class="mkdf-btn mkdf-btn-medium mkdf-btn-solid><span class="mkdf-btn-text">Back to home</span></a>';
	}


	?>
</div>
</div>
</div>
</div>
</div>
<?php wp_footer(); ?>
</body>
</html>